<?php
/* This file has been auto-generated. Do not edit this file directly. */

abstract class Sabai_Addon_System_Model_Base_AddonGateway extends SabaiFramework_Model_Gateway
{
    public function getName()
    {
        return 'system_addon';
    }

    public function getFields()
    {
        return array('addon_name' => SabaiFramework_Model::KEY_TYPE_VARCHAR, 'addon_version' => SabaiFramework_Model::KEY_TYPE_VARCHAR, 'addon_params' => SabaiFramework_Model::KEY_TYPE_TEXT, 'addon_priority' => SabaiFramework_Model::KEY_TYPE_INT, 'addon_events' => SabaiFramework_Model::KEY_TYPE_TEXT, 'addon_parent_addon' => SabaiFramework_Model::KEY_TYPE_VARCHAR, 'addon_created' => SabaiFramework_Model::KEY_TYPE_INT, 'addon_updated' => SabaiFramework_Model::KEY_TYPE_INT);
    }

    protected function _getIdFieldName()
    {
        return 'addon_name';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %ssystem_addon WHERE addon_name = %s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $this->_db->escapeString($id)
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %ssystem_addon WHERE addon_name IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map(array($this->_db, 'escapeString'), $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$ssystem_addon system_addon WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['addon_created'] = time();
        $values['addon_updated'] = 0;
        return sprintf('INSERT INTO %ssystem_addon(addon_name, addon_version, addon_params, addon_priority, addon_events, addon_parent_addon, addon_created, addon_updated) VALUES(%s, %s, %s, %d, %s, %s, %d, %d)', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['addon_name']), $this->_db->escapeString($values['addon_version']), $this->_db->escapeString($values['addon_params']), $values['addon_priority'], $this->_db->escapeString(serialize($values['addon_events'])), $this->_db->escapeString($values['addon_parent_addon']), $values['addon_created'], $values['addon_updated']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['addon_updated'];
        $values['addon_updated'] = time();
        return sprintf('UPDATE %ssystem_addon SET addon_version = %s, addon_params = %s, addon_priority = %d, addon_events = %s, addon_parent_addon = %s, addon_updated = %d WHERE addon_name = %s AND addon_updated = %d', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['addon_version']), $this->_db->escapeString($values['addon_params']), $values['addon_priority'], $this->_db->escapeString(serialize($values['addon_events'])), $this->_db->escapeString($values['addon_parent_addon']), $values['addon_updated'], $this->_db->escapeString($id), $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$ssystem_addon WHERE addon_name = %2$s', $this->_db->getResourcePrefix(), $this->_db->escapeString($id));
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['addon_updated'] = 'addon_updated=' . time();
        return sprintf('UPDATE %ssystem_addon system_addon SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE system_addon FROM %1$ssystem_addon system_addon WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$ssystem_addon system_addon WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }
}